﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Activity.master" AutoEventWireup="true" CodeBehind="ActivityUpdates.aspx.cs" Inherits="GUI.Pages.ActivityUpdates" %>
<%@ Register Src="~/Controls/ActivityNavigation.ascx" TagName="ActivityNavigation" TagPrefix="uc" %>
<asp:Content ID="Content3" ContentPlaceHolderID="LeftNavigationPlaceHolder" runat="server">
	<uc:ActivityNavigation ID="ActivityNavigation" runat="server" />
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FormPlaceHolder" runat="server">
	<telerik:RadWindowManager ID="RadWindowManager1" runat="server" EnableShadow="true">
        </telerik:RadWindowManager>
		<telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server" EnableAJAX="true" LoadingPanelID="RadAjaxLoadingPanel1">
        <div class="row">
            <div class="col-md-12 col-sm-12">
            <div class="portlet light bordered light-blue kendo-form">
                    <div class="portlet-title">
                        <div class="caption">
                            <span class="caption-subject bold font-dark uppercase"> <asp:Literal ID="Literal4" runat="server" Text="<%$ Resources:ProjectManagementUI, UI_Notes %>" /> </span>
                        </div>
                    </div>
                    <div class="portlet-body form">
                        <div class="form-body">
                            <div class="row">
                                <div class="col-md-12">
                                       <div class="form-group">
                                            <label class="control-label"><asp:Literal ID="Literal1" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Note %>" /></label>
                                            	<telerik:RadEditor Width="100%" Skin="Bootstrap" Height="200" ID="txtUpdateRich" runat="server" ToolsFile="~/XML/editortools.xml" 
											                        EditModes="Design" StripFormattingOnPaste="AllExceptNewLines" EnableResize="false" EnableAriaSupport="false" 
											                        ToolbarMode="Default" ToolsWidth="600"  OnClientCommandExecuting="OnClientCommandExecuting" >
						                        </telerik:RadEditor>
                                        </div>
                                </div>
                                  <div class="col-md-3">
                                            <div class="form-group">
                                                <label class="control-label"></label> 
                                                       <telerik:RadAsyncUpload runat="server" MultipleFileSelection="Automatic" PostbackTriggers="btnSave" ID="radAsyncUpload" OnClientFileUploaded="onClientFileUploaded"
                                                        Skin="Bootstrap" TemporaryFileExpiration="00:30:00" AllowedFileExtensions="3gp,cdr,psd,config,ai,ips,sql,gzip,mp3,mp4,wma,avi,eps,vsdx,log,fla,psb,aep,skf,odg,qxp,edx,flipchart,cmx,pptm,pub,7z,tar,jpg,jpeg,png,gif,doc,docx,xls,xlsx,csv,pdf,xsn,ppt,pptx,txt,rtf,dwg,kmz,zip,rar,3ds,dxf,fbx,max,mtl,dwl,dwl2,3dm,oda,odb,odc,odf,odg,odh,odi,odl,odm,odp,ods,odt,one,onea,onepkg,onetmp,onetoc,onetoc2,msg"  OnClientFileUploading="ValidateFileName"/>
                                            </div> 
                                    </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <telerik:RadPanelBar runat="server" ID="RadPanelBar1" Width="100%" Skin="Bootstrap" Visible="true">
								        <Items>
									        <telerik:RadPanelItem Expanded="False" Text="<%$ Resources:ProjectManagementUI, Common_NotifyUsers %>">
										        <ContentTemplate>
										                <div class="raw">
                                                            <div class="col-md-12">
                                                                <div class="form-group">
                                                                    <label class="control-label"></label>
                                                                    <div class="mt-checkbox-list">
                                                                        <label class="mt-checkbox bold"> <asp:Literal ID="Literal25" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_SelectAll %>" />
                                                                            <input type="checkbox" id="chkCheckAll"  onchange="javascript:SelektujSve(this.checked);"/>
                                                                            <span></span>
                                                                        </label>
                                                                    </div>

                                                                    <asp:DataList ID="chkUsers" runat="server" RepeatColumns="10">
                                                                        <ItemTemplate>
                                                                             <div class="mt-checkbox-list">
                                                                                <label class="mt-checkbox bold select-users" style="margin-left: 10px;">
                                                                                    <asp:CheckBox ID="checkBoxUser" runat="server" Text='<%#Eval("Name") %>'/>
                                                                                    <asp:HiddenField ID="hdnuserid" runat="server" Value='<%#Eval("Id") %>' />
                                                                                    <span></span>

                                                                                </label>
                                                                            </div>
                                                               
                                                                        </ItemTemplate>
                                                                    </asp:DataList>
                                                                </div>
                                                            </div>
                                                            <div class="col-md-12">
                                                                <div class="form-group">
                                                                    <label class="control-label"><asp:Literal ID="Literal26" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Message %>" /></label>
                                                                    <asp:TextBox CssClass="form-control" Rows="3" Width="100%" TextMode="MultiLine" runat="server" ID="txtComment" />
                                                                </div>
                                                            </div>
										                </div>
									                </ContentTemplate>
									        </telerik:RadPanelItem>
								        </Items>
							        </telerik:RadPanelBar>

                                </div>
                            </div>
                             <div class="form-actions right">
                                 <asp:Button ID="btnSave" OnClick="BtnSaveClick" CssClass="btn red" Text="<%$ Resources:ProjectManagementUI, Common_Save %>" runat="server" />
                                 <asp:Button ID="btnNew" OnClick="BtnNewClick" CssClass="btn blue" Text="<%$ Resources:ProjectManagementUI, Common_Cancel %>" runat="server" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 col-sm-12">
                <div class="portlet light bordered light-blue kendo-form">
                        <div class="portlet-body">
                            <div class="timeline">
                            <asp:Repeater ID="rptUpdates" runat="server" 
				                onitemdatabound="rptUpdates_ItemDataBound">
				                <ItemTemplate>
                                        <!-- TIMELINE ITEM -->
                                        <div class="timeline-item">
                                            <div class="timeline-badge">
                                                <img class="timeline-badge-userpic"  id="imgAvatar" runat="server" src="~/repository/img/no-avatar.png"> </div>
                                            <div class="timeline-body">
                                                <div class="timeline-body-arrow"> </div>
                                                <div class="timeline-body-head">
                                                    <div class="timeline-body-head-caption">
                                                        <a href="javascript:;" class="timeline-body-title font-blue-madison"><asp:Literal ID="ltrUser" runat="server" Mode="PassThrough" /></a>
                                                        <span class="timeline-body-time font-grey-cascade"><asp:Literal ID="ltrDate" runat="server" Mode="PassThrough" /></span>
                                                    </div>
                                                    <div class="timeline-body-head-actions">
                                                        <div class="btn-group">
                                                            <a class="btn red btn-sm lnk-delete " id="lnkDelete" runat="server"> <i class="fa fa-trash"></i> </a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="timeline-body-content">
                                                    <div class="row commentars">
                                                        <div class="col-md-12">
                                                            <span><asp:Literal ID="ltrUpdate" runat="server" Mode="PassThrough" /></span>
                                                        </div>
                                                    </div>
                                                    <div class=" row files">
                                                        <div class="col-md-12">
                                                                <asp:Literal ID="ltrFiles" runat="server" Mode="PassThrough" />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- END TIMELINE ITEM -->
                                    </ItemTemplate>
			                    </asp:Repeater>
                            </div>			                                  
                        </div>
                    </div>
                </div>
            </div>

		</telerik:RadAjaxPanel>
	<telerik:RadAjaxLoadingPanel runat="server" ID="RadAjaxLoadingPanel1"  ClientIDMode="Static" >
        <div class="updatePanelProgress"><asp:Literal ID="Literal8" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_PleaseWait %>" />...</div>
    </telerik:RadAjaxLoadingPanel>



</asp:Content>

<asp:Content ID="Content1" ContentPlaceHolderID="ScriptPlacerholder" runat="server">
    <script type="text/javascript">

        (function () {



            window.onClientFileUploaded = function (radAsyncUpload, args) {

                var row = args.get_row(),

                    inputName = radAsyncUpload.getAdditionalFieldID("TextBox"),

                    inputType = "text",

                    inputID = inputName,

                    input = createInput(inputType, inputID, inputName),

                    label = createLabel(inputID),

                    br = document.createElement("br");



                row.appendChild(br);

                row.appendChild(label);

                row.appendChild(input);

            }



            function createInput(inputType, inputID, inputName) {

                var input = document.createElement("input");



                input.setAttribute("type", inputType);

                input.setAttribute("id", inputID);

                input.setAttribute("name", inputName);



                return input;

            }
            function ValidateFileName(sender, args) {
                //filename to validate

                if (args.get_fileName().length > 50)
                    args.set_cancel(true);
            }


            function createLabel(forArrt) {

                var label = document.createElement("label");



                label.setAttribute("for", forArrt);

                label.innerHTML = "File info: ";



                return label;

            }

        })();

        function SelektujSve(stat) {
            var selall = stat;
            $('.select-users input').each(function () { $(this).prop('checked', selall) });
        }


	    function pageLoad(sender, args) {
	        $(document).ready(function () {
	            $(".lnk-delete").each(function () {
	                $(this).bind("click", function () {
	                    var updateId = $(this).attr('updateId');

	                    radalert(confirm, 330, 100, war,
                         function () {
                             RequestStart("RadAjaxLoadingPanel1", "updatesWrapper");
                             var paramList = '{"updateId":"' + updateId + '"}';
                             $.ajax({
                                 type: "POST",
                                 url: appRoot + "/Pages/ActivityUpdates.aspx/DeleteUpdate",
                                 data: paramList,
                                 contentType: "application/json; charset=utf-8",
                                 dataType: "json",
                                 success: function (msg) {

                                     if (msg.d.Passed) {
                                         location.reload();
                                         //ResponseEnd();
                                     }
                                     else {
                                         //ResponseEnd();
                                         $('#reveal-title').html('Greska');
                                         $('#reveal-text').html(msg.d.Message);
                                         $('#divMessageBox').foundation('reveal', 'open');
                                     }
                                     ResponseEnd();
                                 }
                             });


                         }
                         , "0");





	                });
	            });

	        });

	    }


	    function OnClientCommandExecuting(editor, args) {
	        var commandName = args.get_commandName();
	        if (commandName == "LinkManager") {
	            editor.setFocus();

	            //FireFox - will work only if there is selection of text, otherwise built-in browser command does not work   
	            if (!document.all) {
	                var href = prompt("Enter a URL:", "http://");
	                if (href) editor.get_document().execCommand("createlink", false, href);
	            }
	            else editor.get_document().execCommand("createlink", true, null);

	            //Cancel the further execution of the command to avoid error   
	            args.set_cancel(true);
	        }
	    }
	    function ValidateFileName(sender, args) {
	        //filename to validate

	        if (args.get_fileName().length > 50)
	            args.set_cancel(true);
	    }
        
	</script>
</asp:Content>

